#include <windows.h>
#include <stdio.h>
#include <tchar.h>

#include "Util.h"
#include "Application.h"



namespace Util
{

  void EnumFilesInDirectory( const char* szFindMask, std::list<std::string>& listFiles )
  {

    WIN32_FIND_DATAA   wFindData;

    listFiles.clear();

    std::string      strDir = szFindMask;

    size_t    iPos = strDir.find_last_of( '\\' );
    
    if ( iPos == std::string::npos )
    {
      strDir.clear();
    }
    else
    {
      strDir = strDir.substr( 0, iPos + 1 );
    }

    if ( strDir.empty() )
    {
      char            szTemp[MAX_PATH];
      GetCurrentDirectoryA( MAX_PATH, szTemp );

      strDir = szTemp;

      if ( ( !strDir.empty() )
      &&   ( strDir[strDir.length() - 1] != '\\' ) )
      {
        strDir += '\\';
      }
    }


    if ( strDir.find_last_of( '\\' ) != std::string::npos )
    {
      // mit Backslash!
      strDir = strDir.substr( 0, strDir.find_last_of( '\\' ) + 1 );
    }

    HANDLE    hFind = FindFirstFileA( szFindMask, &wFindData );
    if ( hFind == INVALID_HANDLE_VALUE )
    {
      return;
    }
    while ( hFind != INVALID_HANDLE_VALUE )
    {
      if ( wFindData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY )
      {
      }
      else
      {
        listFiles.push_back( strDir + wFindData.cFileName );
      }
      if ( !FindNextFileA( hFind, &wFindData ) )
      {
        FindClose( hFind );
        return;
      }
    }
  }

  const char* AppPath( const char* formatstr, ... )
  {

    static char         szBuffer[3000];

    static char         szModulePath[MAX_PATH];

    static char         szAppPath[MAX_PATH];
    
    static bool         bAppPathSet = false;


    vsprintf( szBuffer, formatstr, (char *)( &formatstr + 1 ) );

    if ( bAppPathSet )
    {
      sprintf( szModulePath, "%s%s", szAppPath, szBuffer );
      return szModulePath;
    }

    GetModuleFileNameA( NULL, szModulePath, MAX_PATH );
    while ( szModulePath[strlen( szModulePath ) - 1] != 92 )
    {
      szModulePath[strlen( szModulePath ) - 1] = 0;
    }

    if ( strlen( szModulePath ) >= 8 )
    {
      // falls wir im RELEASE-Verzeichnis sind, das RELEASE wegmachen
      // (faule-Programmierer-Aktion)
      if ( ( toupper( szModulePath[strlen( szModulePath ) - 8] ) == 'R' )
      &&   ( toupper( szModulePath[strlen( szModulePath ) - 7] ) == 'E' )
      &&   ( toupper( szModulePath[strlen( szModulePath ) - 6] ) == 'L' )
      &&   ( toupper( szModulePath[strlen( szModulePath ) - 5] ) == 'E' )
      &&   ( toupper( szModulePath[strlen( szModulePath ) - 4] ) == 'A' )
      &&   ( toupper( szModulePath[strlen( szModulePath ) - 3] ) == 'S' )
      &&   ( toupper( szModulePath[strlen( szModulePath ) - 2] ) == 'E' ) )
      {
        szModulePath[strlen( szModulePath ) - 1] = 1;
        while ( szModulePath[strlen( szModulePath ) - 1] != 92 )
        {
          szModulePath[strlen( szModulePath ) - 1] = 0;
        }
      }
    }
    if ( strlen( szModulePath ) >= 6 )
    {
      // falls wir im DEBUG-Verzeichnis sind, das DEBUG wegmachen
      // (faule-Programmierer-Aktion)
      if ( ( toupper( szModulePath[strlen( szModulePath ) - 6] ) == 'D' )
      &&   ( toupper( szModulePath[strlen( szModulePath ) - 5] ) == 'E' )
      &&   ( toupper( szModulePath[strlen( szModulePath ) - 4] ) == 'B' )
      &&   ( toupper( szModulePath[strlen( szModulePath ) - 3] ) == 'U' )
      &&   ( toupper( szModulePath[strlen( szModulePath ) - 2] ) == 'G' ) )
      {
        szModulePath[strlen( szModulePath ) - 1] = 1;
        while ( szModulePath[strlen( szModulePath ) - 1] != 92 )
        {
          szModulePath[strlen( szModulePath ) - 1] = 0;
        }
      }
    }

    sprintf( szAppPath, szModulePath );
    bAppPathSet = true;

    return strcat( szModulePath, szBuffer );

  }

  unsigned int ModulateColor( unsigned int Color1, unsigned int Color2 )
  {
    int   A1 = ( Color1 & 0xfe000000 ) >> 25;
    int   A2 = ( Color2 & 0xfe000000 ) >> 25;
    int   R1 = ( Color1 & 0x00fe0000 ) >> 17;
    int   R2 = ( Color2 & 0x00fe0000 ) >> 17;
    int   G1 = ( Color1 & 0x0000fe00 ) >>  9;
    int   G2 = ( Color2 & 0x0000fe00 ) >>  9;
    int   B1 = ( Color1 & 0x000000fe ) >> 1;
    int   B2 = ( Color2 & 0x000000fe ) >> 1;

    return ( ( A1 + A2 ) << 24 ) + ( ( R1 + R2 ) << 16 ) + ( ( G1 + G2 ) << 8 ) + ( B1 + B2 );
  }

  unsigned int ModulateColor( unsigned int Color1, unsigned int Color2, float Factor )
  {
    int   A1 = ( Color1 & 0xff000000 ) >> 24;
    int   A2 = ( Color2 & 0xff000000 ) >> 24;
    int   R1 = ( Color1 & 0x00ff0000 ) >> 16;
    int   R2 = ( Color2 & 0x00ff0000 ) >> 16;
    int   G1 = ( Color1 & 0x0000ff00 ) >>  8;
    int   G2 = ( Color2 & 0x0000ff00 ) >>  8;
    int   B1 = ( Color1 & 0x000000ff ) >>  0;
    int   B2 = ( Color2 & 0x000000ff ) >>  0;

    return ( ( (int)( A1 * Factor + A2 * ( 1.0f - Factor ) ) ) << 24 )
         + ( ( (int)( R1 * Factor + R2 * ( 1.0f - Factor ) ) ) << 16 )
         + ( ( (int)( G1 * Factor + G2 * ( 1.0f - Factor ) ) ) <<  8 )
         + ( ( (int)( B1 * Factor + B2 * ( 1.0f - Factor ) ) ) <<  0 );
  }



}
